/* Linker script for Stellaris LM3S9B92
 *
 * Version: Sourcery G++ 4.4-180
 * Support: https://support.codesourcery.com/GNUToolchain/
 *
 * Copyright (c) 2007, 2008, 2009, 2010 CodeSourcery, Inc.
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions.  No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */
OUTPUT_FORMAT ("elf32-littlearm", "elf32-bigarm", "elf32-littlearm")
ENTRY(start)
SEARCH_DIR(.)
/*GROUP(-lgcc -lc -lcs3 -lcs3hosted -lcs3stellaris_tempest)*/

MEMORY
{
  rom (rwx)  : ORIGIN = 0x20000400, LENGTH = 3K
  input(rwx)  : ORIGIN = 0x20000E00, LENGTH = 64
  output (rwx)  : ORIGIN = 0x20000E40, LENGTH = 64
  inoutput(rwx)  : ORIGIN = 0x20000E80, LENGTH = 64
  ram (rwx)  : ORIGIN = 0x20000EC0, LENGTH = 288
}

/* These force the linker to search for particular symbols from
 * the start of the link process and thus ensure the user's
 * overrides are picked up
 */
EXTERN(_start)

SECTIONS {
  .text : {
  *(.boot)
  *(.text)
  } > rom
  .inputs : {  
   *(.inputs)
   } > input
  .outputs : {  
   *(.outputs)
   } > output  
  .inoutputs : {  
   *(.inoutputs)
   } > inoutput  
  .data : {  
   *(.data) 
   } > ram
  .bss :  { *(.bss)  *(COMMON) } > ram
}
/* checksum: 1009d72a5df8abf47006 */
